<?php

namespace YOOtheme\Demo;

use YOOtheme\Str;

class Helper
{
    public static function matchNode($match, $node)
    {
        foreach ($match as $prop => $value) {
            if (is_array($value)) {
                foreach ($value as $key => $val) {
                    if (!isset($node->$prop[$key]) || !Str::is($val, $node->$prop[$key])) {
                        return false;
                    }
                }
            } elseif (!isset($node->$prop) || !Str::is($value, $node->$prop)) {
                return false;
            }
        }

        return true;
    }

    public static function relativePath($from, $to)
    {
        $fromParts = explode('/', ltrim($from, '/'));
        $toParts = explode('/', ltrim($to, '/'));

        $match = true;
        $prefix = '';

        foreach ($fromParts as $i => $fromPart) {
            if ('' === $fromPart) {
                continue;
            }

            if ($match && isset($toParts[$i]) && $fromPart === $toParts[$i]) {
                unset($toParts[$i]);
                continue;
            }

            $match = false;
            $prefix .= '../';
        }

        return rtrim($prefix . join('/', $toParts), '/');
    }
}
